#include <bits/stdc++.h>

using namespace std;

int n;

struct Query
{
    int l, r, idx;
    int block;

    bool operator<(Query const &o) const
    {
        if (block != o.block)
        {
            return block < o.block;
        }
        if (block & 1)
        {
            return r > o.r;
        }
        else
        {
            return r < o.r;
        }
    }
};

int main(){
    ios::sync_with_stdio(false);
    cin.tie(NULL);

    // Ulaz
    cin >> n;
    vector<int long long> a(n+1);
    for(int i=1;i<=n;i++)
    {
        cin>>a[i];
    }

    // 1) kompresija a[i]
    vector<int long long> vals(a.begin()+1, a.end());
    sort(vals.begin(), vals.end());
    vals.erase(unique(vals.begin(), vals.end()), vals.end());
    int M = vals.size();
    vector<int> comp(n+1);
    for(int i=1;i<=n;i++)
    {
        comp[i] = int(lower_bound(vals.begin(), vals.end(), a[i]) - vals.begin());
    }

    // 2) prefiksne S[0..n]
    vector<int long long> S(n+1,0);
    for(int i=1;i<=n;i++)
    {
        S[i] = S[i-1] + a[i];
    }

    // 3) grupisanje pozicija po prefiksnim
    unordered_map<int long long, vector<int>> mp;
    mp.reserve(n*2);
    for(int i=0;i<=n;i++)
    {
        mp[S[i]].push_back(i);
    }

    // 4) pravimo upite [L..R]
    vector<Query> Qs;
    for(auto &it: mp)
    {
        auto &vec = it.second;
        if(vec.size() >= 2)
        {
            int L = vec.front() + 1;
            int R = vec.back();
            if(L <= R)
            {
                Query q;
                q.l = L; q.r = R; q.idx = Qs.size();
                Qs.push_back(q);
            }
        }
    }

    // podesavamo blok za ??
    int blockSize = max(1, int(sqrt(n)));
    for(auto &q: Qs){
        q.block = q.l / blockSize;
    }
    sort(Qs.begin(), Qs.end());

    // 5) mode frequency algoritam
    vector<int> freq(M,0);
    vector<int> cnt(n+2,0);
    int currL = 1, currR = 0;
    int current_max = 0;
    int answer = 0;

    auto add = [&](int pos)
    {
        int x = comp[pos];
        int f = freq[x];
        cnt[f]--;
        freq[x]++;
        cnt[freq[x]]++;
        if(freq[x] > current_max)
        {
            current_max = freq[x];
        }
    };
    auto remove = [&](int pos)
    {
        int x = comp[pos];
        int f = freq[x];
        cnt[f]--;
        freq[x]--;
        cnt[freq[x]]++;
        if(cnt[current_max] == 0)
        {
            current_max--;
        }
    };

    cnt[0] = M;
    for(auto &q: Qs)
    {
        while(currL > q.l) add(--currL);
        while(currR < q.r) add(++currR);
        while(currL < q.l) remove(currL++);
        while(currR > q.r) remove(currR--);
        answer = max(answer, current_max);
    }

    cout<<answer<<endl;
    return 0;
}